/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.sax;

import com.aptana.core.logging.IdeLog;
import com.aptana.parsing.ParsingPlugin;
import com.aptana.sax.IValidatingReaderLogger;
import com.aptana.sax.InvalidTransitionException;
import com.aptana.sax.Schema;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.Plugin;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatingReader
extends DefaultHandler {
    protected Schema _schema;
    protected IValidatingReaderLogger _logger;
    protected Locator _locator;

    protected ValidatingReader() {
        this(null);
    }

    public ValidatingReader(Schema schema) {
        if (schema == null) {
            schema = new Schema();
        }
        this._schema = schema;
    }

    protected Map<String, String> attributesToMap(Attributes attributes, boolean trim) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (attributes != null) {
            int i = 0;
            while (i < attributes.getLength()) {
                String name = attributes.getLocalName(i);
                String value = trim ? attributes.getValue(i).trim() : attributes.getValue(i);
                result.put(name, value);
                ++i;
            }
        }
        return result;
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qualifiedName) throws SAXException {
        if (this._schema != null) {
            try {
                this._schema.exitElement(namespaceURI, localName, qualifiedName);
            }
            catch (IllegalArgumentException e) {
                throw new SAXException(e);
            }
            catch (IllegalAccessException e) {
                throw new SAXException(e);
            }
            catch (InvocationTargetException e) {
                throw new SAXException(e);
            }
        }
    }

    public void logError(String message) {
        if (this._logger != null && this._locator != null) {
            this._logger.logError(message, this._locator.getLineNumber(), 0);
        } else {
            IdeLog.logError((Plugin)ParsingPlugin.getDefault(), (String)message);
        }
    }

    public void logInfo(String message) {
        if (this._logger != null) {
            this._logger.logInfo(message, this._locator.getLineNumber(), 0);
        } else {
            IdeLog.logInfo((Plugin)ParsingPlugin.getDefault(), (String)message);
        }
    }

    public void logWarning(String message) {
        if (this._logger != null) {
            this._logger.logWarning(message, this._locator.getLineNumber(), 0);
        } else {
            IdeLog.logWarning((Plugin)ParsingPlugin.getDefault(), (String)message);
        }
    }

    public void read(InputStream in) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        SAXParser saxParser = factory.newSAXParser();
        saxParser.parse(in, (DefaultHandler)this);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        super.setDocumentLocator(locator);
        this._locator = locator;
    }

    public void setLogger(IValidatingReaderLogger logger) {
        this._logger = logger;
    }

    @Override
    public void startDocument() {
        if (this._schema != null) {
            this._schema.reset();
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes attributes) throws SAXException {
        if (this._schema != null) {
            try {
                this._schema.moveTo(namespaceURI, localName, qualifiedName, attributes);
            }
            catch (IllegalArgumentException e) {
                throw new SAXException(e);
            }
            catch (InvalidTransitionException e) {
                throw new SAXException(e);
            }
            catch (IllegalAccessException e) {
                throw new SAXException(e);
            }
            catch (InvocationTargetException e) {
                Throwable innerException = e.getCause();
                if (innerException instanceof SAXException) {
                    throw (SAXException)innerException;
                }
                throw new SAXException(e);
            }
        }
    }
}

